/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.buzzier_bees.common.blocks;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.FlintAndSteelItem;
import net.minecraft.item.ShovelItem;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.quark.api.IEnchantmentInfluencer;

public class CandleBlock
extends Block
implements IWaterLoggable,
IEnchantmentInfluencer {
    public static final IntegerProperty CANDLES = IntegerProperty.func_177719_a((String)"candles", (int)1, (int)4);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final BooleanProperty LIT = BlockStateProperties.field_208190_q;
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    private final DyeColor color;
    public static final double XZ_PARTICLE_SPEED = (double)0.002f;
    public static final double Y_PARTICLE_SPEED = (double)0.01f;
    protected static final VoxelShape[] SHAPES = new VoxelShape[]{Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)9.0, (double)10.0), Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)9.0, (double)13.0), Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)9.0, (double)13.0), Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)9.0, (double)13.0)};

    public CandleBlock(DyeColor color, AbstractBlock.Properties properties) {
        super(properties);
        this.color = color;
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)CANDLES, (Comparable)Integer.valueOf(1))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(true)));
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState blockstate = context.func_195991_k().func_180495_p(context.func_195995_a());
        Direction direction = context.func_195992_f();
        if (blockstate.func_177230_c() == this) {
            return (BlockState)((BlockState)blockstate.func_206870_a((Property)FACING, (Comparable)direction)).func_206870_a((Property)CANDLES, (Comparable)Integer.valueOf(Math.min(4, (Integer)blockstate.func_177229_b((Property)CANDLES) + 1)));
        }
        FluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        boolean flag = ifluidstate.func_206884_a((ITag)FluidTags.field_206959_a) && ifluidstate.func_206882_g() == 8;
        return (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)direction)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag))).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(!flag));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!((Boolean)state.func_177229_b((Property)LIT)).booleanValue() && player.func_184586_b(handIn).func_77973_b() instanceof FlintAndSteelItem) {
            worldIn.func_184133_a(player, pos, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, worldIn.func_201674_k().nextFloat() * 0.4f + 0.8f);
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.TRUE), 11);
            player.func_184586_b(handIn).func_222118_a(1, (LivingEntity)player, p_219999_1_ -> p_219999_1_.func_213334_d(handIn));
            return ActionResultType.func_233537_a_((boolean)worldIn.func_201670_d());
        }
        if (((Boolean)state.func_177229_b((Property)LIT)).booleanValue() && player.func_184586_b(handIn).func_77973_b() instanceof ShovelItem) {
            if (!worldIn.func_201670_d()) {
                worldIn.func_217378_a(null, 1009, pos, 0);
            }
            player.func_184586_b(handIn).func_222118_a(1, (LivingEntity)player, p_219999_1_ -> p_219999_1_.func_213334_d(handIn));
            worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.FALSE));
            return ActionResultType.func_233537_a_((boolean)worldIn.func_201670_d());
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return mirrorIn == Mirror.NONE ? state : state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return CandleBlock.func_220055_a((IWorldReader)worldIn, (BlockPos)pos.func_177977_b(), (Direction)Direction.UP);
    }

    public float getEnchantPowerBonus(BlockState state, IWorldReader world, BlockPos pos) {
        return 0.1f * (float)((Integer)state.func_177229_b((Property)CANDLES)).intValue();
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!state.func_196955_c((IWorldReader)worldIn, currentPos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            if (((Boolean)state.func_177229_b((Property)LIT)).booleanValue()) {
                worldIn.func_180501_a(currentPos, (BlockState)state.func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false)), 2);
            }
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(state, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        return useContext.func_195996_i().func_77973_b() == this.func_199767_j() && (Integer)state.func_177229_b((Property)CANDLES) < 4 || super.func_196253_a(state, useContext);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPES[(Integer)state.func_177229_b((Property)CANDLES) - 1];
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{CANDLES, WATERLOGGED, LIT, FACING});
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return type == PathType.AIR && !this.field_235688_at_ || super.func_196266_a(state, worldIn, pos, type);
    }

    public IParticleData getFlameParticle() {
        return ParticleTypes.field_197631_x;
    }

    public IParticleData getSmokeParticle() {
        return ParticleTypes.field_197601_L;
    }

    public DyeColor getColor() {
        return this.color;
    }

    @Override
    @Nullable
    public DyeColor getEnchantmentInfluenceColor(IBlockReader world, BlockPos pos, BlockState state) {
        return this.getColor();
    }

    @Override
    public int getInfluenceStack(IBlockReader world, BlockPos pos, BlockState state) {
        return (Integer)state.func_177229_b((Property)CANDLES);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        if (((Boolean)state.func_177229_b((Property)LIT)).booleanValue()) {
            double x = pos.func_177958_n();
            double y = pos.func_177956_o();
            double z = pos.func_177952_p();
            IParticleData smokeParticle = this.getSmokeParticle();
            IParticleData flameParticle = this.getFlameParticle();
            block0 : switch ((Integer)state.func_177229_b((Property)CANDLES)) {
                case 1: {
                    this.addCandleParticleEffects(world, flameParticle, smokeParticle, x + 0.5, y + 0.75, z + 0.5);
                    break;
                }
                case 2: {
                    switch ((Direction)state.func_177229_b((Property)FACING)) {
                        case NORTH: {
                            this.addCandleParticleEffects(world, flameParticle, smokeParticle, x + 0.5625, y + 0.75, z + 0.3125);
                            this.addCandleParticleEffects(world, flameParticle, smokeParticle, x + 0.375, y + 0.625, z + 0.625);
                            break;
                        }
                        case EAST: {
                            this.addCandleParticleEffects(world, flameParticle, smokeParticle, x + 0.6875, y + 0.75, z + 0.5625);
                            this.addCandleParticleEffects(world, flameParticle, smokeParticle, x + 0.375, y + 0.625, z + 0.375);
                            break;
                        }
                        case SOUTH: {
                            this.addCandleParticleEffects(world, flameParticle, smokeParticle, x + 0.4375, y + 0.75, z + 0.6875);
                            this.addCandleParticleEffects(world, flameParticle, smokeParticle, x + 0.625, y + 0.625, z + 0.375);
                            break;
                        }
                        case WEST: {
                            this.addCandleParticleEffects(world, flameParticle, smokeParticle, x + 0.3125, y + 0.75, z + 0.4375);
                            this.addCandleParticleEffects(world, flameParticle, smokeParticle, x + 0.625, y + 0.625, z + 0.625);
                        }
                    }
                    break;
                }
                case 3: {
                    switch ((Direction)state.func_177229_b((Property)FACING)) {
                        case NORTH: {
                            this.addCandleParticleEffects(world, flameParticle, smokeParticle, x + 0.6875, y + 0.75, z + 0.375);
                            this.addCandleParticleEffects(world, flameParticle, smokeParticle, x + 0.5, y + 0.6875, z + 0.6875);
                            this.addCandleParticleEffects(world, flameParticle, smokeParticle, x + 0.3125, y + 0.625, z + 0.3125);
                            break;
                        }
                        case EAST: {
                            this.addCandleParticleEffects(world, flameParticle, smokeParticle, x + 0.625, y + 0.75, z + 0.6875);
                            this.addCandleParticleEffects(world, flameParticle, smokeParticle, x + 0.3125, y + 0.6875, z + 0.5);
                            this.addCandleParticleEffects(world, flameParticle, smokeParticle, x + 0.6875, y + 0.625, z + 0.3125);
                            break;
                        }
                        case SOUTH: {
                            this.addCandleParticleEffects(world, flameParticle, smokeParticle, x + 0.3125, y + 0.75, z + 0.625);
                            this.addCandleParticleEffects(world, flameParticle, smokeParticle, x + 0.5, y + 0.6875, z + 0.3125);
                            this.addCandleParticleEffects(world, flameParticle, smokeParticle, x + 0.6875, y + 0.625, z + 0.6875);
                            break;
                        }
                        case WEST: {
                            this.addCandleParticleEffects(world, flameParticle, smokeParticle, x + 0.375, y + 0.75, z + 0.3125);
                            this.addCandleParticleEffects(world, flameParticle, smokeParticle, x + 0.6875, y + 0.6875, z + 0.5);
                            this.addCandleParticleEffects(world, flameParticle, smokeParticle, x + 0.3125, y + 0.625, z + 0.6875);
                        }
                    }
                    break;
                }
                default: {
                    switch ((Direction)state.func_177229_b((Property)FACING)) {
                        case NORTH: {
                            this.addCandleParticleEffects(world, flameParticle, smokeParticle, x + 0.6875, y + 0.75, z + 0.3125);
                            this.addCandleParticleEffects(world, flameParticle, smokeParticle, x + 0.625, y + 0.6875, z + 0.625);
                            this.addCandleParticleEffects(world, flameParticle, smokeParticle, x + 0.3125, y + 0.625, z + 0.375);
                            this.addCandleParticleEffects(world, flameParticle, smokeParticle, x + 0.3125, y + 0.4375, z + 0.6875);
                            break block0;
                        }
                        case EAST: {
                            this.addCandleParticleEffects(world, flameParticle, smokeParticle, x + 0.6875, y + 0.75, z + 0.6875);
                            this.addCandleParticleEffects(world, flameParticle, smokeParticle, x + 0.375, y + 0.6875, z + 0.625);
                            this.addCandleParticleEffects(world, flameParticle, smokeParticle, x + 0.625, y + 0.625, z + 0.3125);
                            this.addCandleParticleEffects(world, flameParticle, smokeParticle, x + 0.3125, y + 0.4375, z + 0.3125);
                            break block0;
                        }
                        case SOUTH: {
                            this.addCandleParticleEffects(world, flameParticle, smokeParticle, x + 0.3125, y + 0.75, z + 0.6875);
                            this.addCandleParticleEffects(world, flameParticle, smokeParticle, x + 0.375, y + 0.6875, z + 0.375);
                            this.addCandleParticleEffects(world, flameParticle, smokeParticle, x + 0.6875, y + 0.625, z + 0.625);
                            this.addCandleParticleEffects(world, flameParticle, smokeParticle, x + 0.6875, y + 0.4375, z + 0.3125);
                            break block0;
                        }
                        case WEST: {
                            this.addCandleParticleEffects(world, flameParticle, smokeParticle, x + 0.3125, y + 0.75, z + 0.3125);
                            this.addCandleParticleEffects(world, flameParticle, smokeParticle, x + 0.625, y + 0.6875, z + 0.375);
                            this.addCandleParticleEffects(world, flameParticle, smokeParticle, x + 0.375, y + 0.625, z + 0.6875);
                            this.addCandleParticleEffects(world, flameParticle, smokeParticle, x + 0.6875, y + 0.4375, z + 0.6875);
                        }
                    }
                }
            }
        }
    }

    public void addCandleParticleEffects(World world, IParticleData flameParticle, IParticleData smokePartice, double x, double y, double z) {
        world.func_195594_a(flameParticle, x, y, z, (double)0.002f, (double)0.01f, (double)0.002f);
        world.func_195594_a(smokePartice, x, y, z, (double)0.002f, (double)0.01f, (double)0.002f);
    }
}

